include <../DobloFactory/doblo-factory.scad>;
include <../DobloFactory/lib/doblo-params.scad>;

/* Code proposed by D. Schneider in combination with noun project icons from
https://thenounproject.com/

Credits:

Traffic sign based on work by Federico Panzano, Genova
https://thenounproject.com/panzano/collection/usa-traffic-signs/?oq=traffic%20signs&cidx=3&i=163023
*/

// Variants

icon_brick("animaux.dxf",x_off=1,y_off=2,width=4,length=4, out=false, d_scale=0.05, d_height=4);

unit = NBO(LUGO);

// meanigful height params = 3,4,5
module icon_brick (DXF,x_off=5, y_off=3, width=4, length=4,
		   out=true, d_scale=1, d_height=4) {
     if (out==true) {
	  color ("lightblue") doblo (col=0,  row=-4, up=0,  
				     width=width,  length=length, height=HALF, 
				     nibbles_on_off=false,
				     diamonds_on_off=false,
				     scale=LUGO);
	  color ("lightblue") block (col=0,  row=-4, up=HALF,  
				     width=width,  length=length, height=HALF, 
				     nibbles_on_off=false,
				     diamonds_on_off=false,
				     scale=LUGO);
	  translate ([x_off,y_off,FULL+d_height]) // embed the thing a bit
	  {
	       color ("pink")
		    scale ([d_scale,d_scale,1]) 
		    linear_extrude(height = d_height+1, center = true, convexity = 10)
		    import (file = DXF);
	  }
     }
     else
     {
	  difference () {
	       union () {
		    color ("lightgrey") doblo (col=0,  row=-4, up=0,  
					       width=width,  length=length, height=HALF, 
					       nibbles_on_off=false,
					       diamonds_on_off=false,
					       scale=LUGO);
		    color ("lightgrey") block (col=0,  row=-4, up=HALF,  
					       width=width,  length=length, height=HALF, 
					       nibbles_on_off=false,
					       diamonds_on_off=false,
					       scale=LUGO);
	       }
	       
	       #translate ([x_off+1.5,y_off+1.5,FULL+THIRD]) {
		    color ("pink")
			 scale ([d_scale,d_scale,1])
			 linear_extrude(height = d_height+2, center = true, convexity = 10)
			 import (file = DXF);
	       }
	  }
}
}