teeth = 8;
teeth_dia = ((1.591 * pow(teeth,1.064)) / (0.6523 + pow(teeth,1.064)))*teeth; // Outside diameter of teeth

tooth_width = 2.85; // width of base of tooth
tooth_angle = 40; // angle of tooth sides
tooth_height = 1.3; // height of tooth

//tooth

module spur()
	{
	polygon([[0,-(tooth_width/2)],[0,(tooth_width/2)],[-tooth_height,((tooth_width/2)-(tan(tooth_angle/2)*tooth_height))],[-tooth_height,-((tooth_width/2)-(tan(tooth_angle/2)*tooth_height))]],[[0,1,2,3,0]]);
	}

translate([0,0,8]) 
difference()
	{
    	//shaft
	rotate ([0,0,360/(teeth*4)]) cylinder(r=teeth_dia/2,h=8, $fn=teeth*2);

    	//spurs
	for(i=[1:teeth]) rotate([0,0,i*(360/teeth)])
	translate([teeth_dia/2,0,-1]) linear_extrude(height=10) spur();
	}

module spur8()
	{
		linear_extrude(height=8) polygon([[-1,-1],[-1,1],[0.7,0.7],[0.7,-0.7]],[[0,1,2,3,0]]);
	}

    	//shaft
    rotate ([0,0,22.5]) cylinder(r=5,h=8, $fn=8);
    	
    	//spurs
    	rotate ([0,0,22.5])
	for(i=[1:8]) rotate([0,0,i*(360/8)])
    	translate([5.6,0,0]) spur8();
