// Jewelry Tree:  Thrombic Aorta
// Valentines Day gift for Aunt Ginny
// also can be a game piece for D&D gaming
// by Les Hall
// started 2:43 AM Tue Jan 19 2016
// 



// parameters
all = true;
both = false;
s = 0.15;
k = 1;
u = 15;
v = 2;
w = 2;
num = 64;
nozzleDiameter = 0.5;
thickness = 1;
$fn = 32;



// make the thing
object();



module object() {
    
    shape();
}


// define the thing
module shape() {
    
    // Mom
    trunk();
    
    // Aunt Ginny
    if (all == true) {

        rotate(120)
        trunk();

        rotate(-120)
        trunk();
    }
}


module trunk() {
    
    // trunk
    half();
    
    // lower branch
    rotate(-90)
    translate([5, 5, 8])
    rotate(-30, [1, 0.5, 0])
    scale(0.7)
    rotate(220)
    half();
    
    // middle branch
    rotate(90)
    translate([-5, 5, 25])
    rotate(-30, [1, 0.5, 0])
    scale(0.7)
    rotate(220)
    half();
    
    // upper branch
    translate([-10, 5, 67])
    rotate(-30, [1, -1, 0])
    scale(0.5)
    half();
    
    if (both == true)
    rotate(180)
    rotate(180, [0, 1, 0])
    half();
}


// define the thing
module half() {
    
    // trunks
    for (n = [0:num*3/4]) {
        
        //segment
        hull() {
            
            section(n);
            
            section(n+1);
        }
    }
}



module section(n) {
    
    // cylinder
    rotate(k * 360 * n/num)
    translate([s*w*(num-n) + nozzleDiameter, 
        0, s*n*u*(cos(360*(n-num/2)))])
    scale([1, 1, 0.333])
    sphere(d=v*2*(num-n)*s);
}



